﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace GeneratorWerIntPliku 
{
    class Program
    {
       static private string DodajZera(string aWart)
       {
          string ret = "";
          for (int i = 0; i < aWart.Length; i++)
             ret += aWart[i] + "\0";
          return ret;
       }

        /// <summary>
        /// Główna funkcja programu podmieniająca wzorzec
        /// </summary>
        /// <param name="aŚcieżka"></param>
        static void ZmodyfikujPlik(string aŚcieżka)
        {
           WsparcieMD5 wsparcieMD5Obj = new WsparcieMD5(aŚcieżka);
           string md5 = wsparcieMD5Obj.MD5Aplikacji();

           // odczyt pliku
           TextReader reader = new StreamReader(aŚcieżka, System.Text.Encoding.Default);
           string zawartość = reader.ReadToEnd();
           reader.Close();

           // modyfikacja zawartości
           int indeksPocz = zawartość.IndexOf(WsparcieMD5.wzorzecBinPoczątek);
           int indeksKon = zawartość.IndexOf(WsparcieMD5.wzorzecBinKoniec);
           if(indeksPocz != -1 && indeksKon != -1)
              zawartość = zawartość.Substring(0, indeksPocz + WsparcieMD5.wzorzecBinPoczątek.Length) +
                DodajZera(md5) + zawartość.Substring(indeksKon);
            
           // zapis pliku
           TextWriter writer = new StreamWriter(aŚcieżka, false, System.Text.Encoding.Default);
           writer.Write(zawartość);
           writer.Close();

           Console.WriteLine(aŚcieżka + " został zmodyfikowany " );
        }

        static void Main(string[] args)
        {
            if(args.Length < 1) 
                Console.WriteLine("Uruchom program z parametrem określającym modyfikowany plik.");
            else if(!File.Exists(args[0]))
                Console.WriteLine("Podany plik nie istnieje.");
            else ZmodyfikujPlik(args[0]);
        }
    }
}
